﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Threading.Tasks;
using UnityEngine;
using UnityEngine.SceneManagement;

//MainMenu is a script for managing the main menu page UI
public class MainMenu : MonoBehaviour
{
    public GameObject MessageBoxObject;
    public GameObject MessageBoxParentContainerObject;

    public void Start()
    {
        //Starting, so let's set up and begin the audio
        AudioManager.Instance.SetMusicVolume(Convert.ToSingle(SettingsManager.Instance.Settings[Constants.Settings.MusicVolume]));
        AudioManager.Instance.SetSFXVolume(Convert.ToSingle(SettingsManager.Instance.Settings[Constants.Settings.SFXVolume]));
        AudioManager.Instance.PlayFile(AudioManager.Instance.LoadedFiles["MainMenuBGM"], true);

        MessageBoxManager.Instance.SetMessageBoxObject(MessageBoxObject, MessageBoxParentContainerObject);

        PageManager.NavigateForward(gameObject.GetComponent<PageDefinition>());
    }

    private async Task TryQuitGame()
    {
        PageManager.CurrentPage.PageGameObject.Disable();

        if (await MessageBoxManager.Instance.Show("Exit Game?", "Are you sure you want to exit the game and return to Windows?", new List<string>() { "No, don't exit", "Yes, exit game" }) == 1)
        {
            Application.Quit();
        }

        PageManager.CurrentPage.PageGameObject.Enable();
    }

    public void QuitGame()
    {
        TryQuitGame();
    }
}
